<?php
require 'admin-login-auth.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin Login | Dubai Treasury Bank</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Bootstrap -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<!-- Custom CSS -->
<link rel="stylesheet" href="assets/admin-login.css">
</head>

<body>

<div class="login-wrapper">

    <div class="login-card">

        <div class="login-header">
            <i class="bi bi-shield-lock"></i>
            <h4>Admin Panel</h4>
            <small>Dubai Treasury Bank</small>
        </div>

        <?php if (isset($error)): ?>
            <div class="alert alert-danger text-center">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <form method="POST">

            <div class="input-group-custom">
                <label>Username</label>
                <input type="text" name="username" placeholder="Enter admin username" required>
            </div>

            <div class="input-group-custom">
                <label>Password</label>
                <input type="password" name="password" placeholder="Enter password" required>
            </div>

            <button type="submit" name="adminLogin" class="primary-btn">
                Login Securely
            </button>

        </form>

    </div>

</div>

</body>
</html>
